<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo https://www.geecom.org/index.php?id=34&alias=linee-guida-per-l%2527uso-del-logo-geecom
    */

    include "include/includeBase.php";
    include "../gUtil/GestoreTabella.php";
    include "../classi/Tabella.php";
    include "include/controlloLogin.php";
    
    $cerca             = isset($_GET["cerca"]) ? filter_input(INPUT_GET,"cerca",FILTER_SANITIZE_ADD_SLASHES) : "";
    
    $parametriRicerca = $cerca!="" ? array("tipo"=>"risorsa","nome"=>$cerca) : array("tipo"=>"risorsa");
    $parametri = array("tabella"=>"geec_categorie", "elementiPerPagina"=>50,"parametriRicerca"=>$parametriRicerca,"ajax"=>false);
        
    $ricerca = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"categorieRisorse.php");
    $ricerca->setOrdinamento("ORDER BY id ASC");
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <title>Amministrazione di Geecom CMS - categorie risorse</title>

    <?php
        include "include/cssBaseAreaAmministrativa.php";
    ?>
</head>

<body>
   
    <header>
        <?php  
            include "include/barraSuperiore.php";

            include "include/header.php";

            include "include/barraMenu.php";
        ?>
    </header>
    
    <main role="main" class="bg-light" id="main">
        <div class="container-fluid">
            <div id="contenutoPrincipale" class="row">
                <?php
                    if(isset($_GET["status"])) {
                        if($_GET["status"]==1) {
                                echo"<p class=\"alert alert-success\">Utente creato</p>";
                        }
                        else if($_GET["status"]==2) {
                                echo"<p class=\"alert alert-success\">Utente modificato</p>";
                        }
                        else if($_GET["status"]==4) {
                                echo"<p class=\"alert alert-success\">Stato dell'amministratore modificato</p>";
                        }
                        else if($_GET["status"]==400) {
                                echo"<p class=\"alert alert-danger\">Indirizzo email già esistente</p>";
                        }
                        else { //status = 5
                                echo"<p class=\"alert alert-success\">Utente eliminato</p>";
                        }
                    }
                ?>

                <div class="container-fluid">
                    <div class="row">
                        <!-- Colonna principale -->
                        <div class="col py-4">
                            <div class="card mb-4 box-shadow-lite">
                                <div class="card-header">
                                    <span class="card-title mr-2"> Categorie risorse</span>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-sm-4 col-xl-3 sticky-top align-self-start">
                                            <form>
                                                <div class="mb-4 add-box">
                                                    <h6 class="mb-3"> Crea una nuova categoria </h6>
                                                    <div class="options-box">
                                                        <div class="form-group">
                                                            <label for="nome-voce-menu-1">Nome</label>
                                                            <input type="text" class="form-control" id="nome" placeholder="Nome">
                                                        </div>
                                                        <button type="button" class="btn btn-primary float-right" value="Crea"  onclick="creaCategoriaRisorsa()"><i class="fas fa-plus mr-2"></i>Crea</button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                        <div class="col-sm-8 col-xl-9 mb-4 gerarchia-menu">
                                            <div id="elencoCategorie" class="row">
                                                <?php 
                                                    $ris = $ricerca->eseguiRicerca(1);
                                                    
                                                    while($categoria = $ris->fetch_assoc()) {
                                                        $nomeEscape = filter_var($categoria["nome"],FILTER_SANITIZE_ADD_SLASHES);
                                                        $numeroUtenti = $geecomDb->contaRigheTabella("geecB_risorse",array("categoria"=>$categoria["id"]));
                                                        echo"<div id=\"categoria{$categoria["id"]}\" class=\"col-sm-6 col-lg-4\">
                                                                <div class=\"card-body mb-3 py-1 px-2 bg-light border rounded d-sm-flex justify-content-between align-items-center text-center\">
                                                                    <div class=\"mb-1 mb-sm-0 text-muted w-50 text-left\">
                                                                        <p class=\"mb-0\"><em><strong>{$categoria["nome"]}</strong></em>  </p>
                                                                        <small><em>$numeroUtenti file</em></small>
                                                                    </div>
                                                                    <div class=\"azioni d-flex align-items-center justify-content-end\">
                                                                        <div class=\"btn-group\" role=\"group\" aria-label=\"Basic example\">
                                                                            <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Modifica\" onclick=\"modificaCategoria({$categoria["id"]},'{$nomeEscape}')\"><i class=\"far fa-edit\"></i></button>
                                                                            <button type=\"button\" class=\"btn btn-light elimina\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Elimina\" onclick=\"eliminaCategoria({$categoria["id"]},'{$nomeEscape}')\" ><i class=\"far fa-trash-alt\"></i></button>
                                                                        </div>
                                                                   </div>
                                                                </div>
                                                            </div>";
                                                    }
                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div><!-- /Colonna principale -->
                    </div>
		</div>
            </div>
        </div>
    </main>
    
    <?php 
        include "include/footer.php";
        
        include "include/modal/modalMenuComponenti.php";
                
        include "include/modal/cambiaPassword.php";
        
        include "include/modal/operazioneCompletata.php";
    ?>
    <div class="modal fade" id="modifica-categoria" tabindex="-1" role="dialog" aria-labelledby="modifica-voce-menu" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Modifica categoria</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                      <form>
                            <input type="text" class="d-none" id="idCategoriaDaModificare" name="id">

                            <div class="form-group">
                                <label for="nome-voce-menu-1">Nome</label>
                                <input type="text" class="form-control" id="nomeCategoriaModificare" name="nome" placeholder="Nome">
                            </div>
                      </form>
                </div>
                <div class="modal-footer">
                      <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                      <button type="button" class="btn btn-primary btn-sm" onclick="eseguiModificaCategoria()"><i class="fas fa-check"></i> Salva</button>
                </div>
            </div>
        </div>
    </div>
    <?php
        include "include/jsBaseAreaAmministrativa.php";
    ?>

    <div class="modal fade" id="modalEliminaElemento" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Eliminare la categoria?</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                    <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="d-flex flex-row justify-content-center">
                        <img id="immagineComponenteDaEliminare" class="thumb d-none d-lg-block" src="">
                        <div class="align-self-center text-center">
                            <span class="align-self-center text-primary"><em id="nomeGruppoDaEliminare"></em></span>
                            <div id="tipoElementoDaEliminare"></div>
                        </div>
                    </div>
                    <input type="text" class="d-none" id="categoriaDaEliminare">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                    <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneCategoria()"><i class="fas fa-check"></i> Elimina</button>
                </div>
            </div>
        </div>
    </div>
    
    <script type="text/javascript">
            
            function creaCategoriaRisorsa() {
                var nome = document.getElementById("nome").value;
                if(nome.length<1) {
                    alert("Il campo è vuoto");
                }
                else {
                    $.ajax({
                        type:"POST",
                        url:"../controller/controllerRisorse.php",
                        data:{
                            operazione:"creaCategoriaRisorsa",
                            id:0,
                            nome:nome
                        },
                        success:function(codice) {
                            var codiceHtmlAttuale = document.getElementById("elencoCategorie").innerHTML;
                            document.getElementById("elencoCategorie").innerHTML = codiceHtmlAttuale + codice;
                        },
                        error: function(xhr,status,error) {
                            alert(status+" "+error);
                        }
                    });
                }
            }
            
            function modificaCategoria(id,nome) {
                $('#idCategoriaDaModificare').val(id);
                $('#nomeCategoriaModificare').val(nome);
                $('#modifica-categoria').modal('show');
            }
       
            function eseguiModificaCategoria() {
                var id    = $('#idCategoriaDaModificare').val();
                var nome  = $('#nomeCategoriaModificare').val();
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerRisorse.php",
                    data:{
                        operazione:"modificaCategoriaRisorsa",
                        idCategoria:id,
                        nome:nome
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaElencoCategorie();
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
    
            function eliminaCategoria(id,nomeElemento) {
                $('#categoriaDaEliminare').val(id);
                $('#nomeGruppoDaEliminare').text(nomeElemento);
                $('#modalEliminaElemento').modal('show');
            }
            
            function aggiornaElencoCategorie() {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerRisorse.php",
                    data:{
                        operazione:"stampaElencoCategorie"
                    },
                    success:function(result) {
                        document.getElementById("elencoCategorie").innerHTML = result;
                        $('#modifica-categoria').modal('hide');
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function eseguiEliminazioneCategoria() {
                var id = $('#categoriaDaEliminare').val();
    
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerRisorse.php",
                    data:{
                        operazione:"eliminaCategoriaRisorsa",
                        id:id
                    },
                    success:function(esito) {
                        if(esito=="ok") {                
                            document.getElementById("categoria"+id).className = "d-none";
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
    
                $('#modalEliminaElemento').modal('hide');
            }
    </script>
</body>
</html>
